/*
  "Bodega", Jaime Vives Piqueres, no(C), 1998
*/

// ----------------------------------------------------------------------------

// *** GLOBAL
#version 3.0
global_settings{
 max_trace_level 10
 ambient_light 0.0
}

// *** STANDARD INC'S
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"
#include "stones.inc"
#include "skies.inc"

// *** RENDER CONTROL
#declare active_camera=      0
#declare trace_scenario=     1
#declare trace_barrels=      1
#declare trace_wine_cup=     1
#declare trace_escanciador=  1
#declare trace_chair=        1
#declare trace_area=         1
#declare trace_ambient_light=1

// +++ scene textures
#include "i_textur.inc"


// ----------------------------------------------------------------------------


// *** BARRELS
#if (trace_barrels=1)
// +++ barrel measures
#declare r_wood=seed(48)
#declare barrel_height=80
#declare barrel_radius=30
#declare lam_ang=10
#declare top_hole=1
// +++ create some barrels
#include "i_barr00.inc"
#declare barrel01=#include "i_barrel.inc"
object{barrel01
 translate (barrel_height*.5+.1)*y
}
cone{
 <0,0,0>,barrel_radius*.07
 <0,4,0>,barrel_radius*.09
 texture{Cork}
 texture{
  pigment{
   granite
   color_map{
    [0 Clear]
    [0.3 Clear]
    [0.4 DarkTan/2 filter 0.7]
    [0.6 DarkTan/3 filter 0.7]
    [.7 Clear]
    [1 Clear]
   }
  }
 }
 rotate 89*x
 rotate -15*y
 translate <-barrel_radius*.5,barrel_height+barrel_radius*.05,0>
}
#declare top_hole=0
#include "i_barr00.inc"
#declare barrel02=#include "i_barrel.inc"
object{barrel02
 rotate 90*x
 translate (barrel_radius+1.1)*y
 translate <-barrel_radius*2-3,0,-5>
}
#end

// ----------------------------------------------------------------------------


// *** WINE CUP
#if (trace_wine_cup=1)
#include "i_wcup.inc"
#declare wine_cup=
union{
 object{cup}
}
// +++ placement
object{wine_cup
 translate <10,(80-.6),0>
}
#end


// ----------------------------------------------------------------------------


// *** SCENARIO
#if (trace_scenario=1)
// +++ floor
#include "i_floor.inc"
object{tiled_floor rotate 90*x translate <0,-1.5,-(max_rows*.5-1)*y_side+1>}
// +++ to avoid micro-holes
plane{y,-1 texture{t_wall_text}}

// +++ old wall
#include "i_oldwll.inc"
object{old_wall
 translate <0,119,44>
}
// simulation of other walls and ceil
plane{x,-200 texture{t_wall_text scale 20}}
plane{x, 200 texture{t_wall_text scale 20}}
plane{y, 250 texture{t_wall_text scale 20}}
#end // end scenario


// ----------------------------------------------------------------------------


// *** ESCANCIADOR (not found in english dict., sorry!)
#if (trace_escanciador=1)
#declare escanciador=
union{
 cone{<0,0,0>,1,<0,12,0>,2}
 box{<-.5,0,-.1>,<.5,70,0> rotate 1*x translate <0,12,2>}
 texture{Silver_Texture}
}
object{escanciador
 rotate 45*y
 rotate 89*x
 rotate 20*y
 translate .5*y
 translate <-10,81,-30>
}
#end


// ----------------------------------------------------------------------------


// *** SPANISH CHAIR (Tipical valencian one)
#if (trace_chair=1)
#declare r_chair=seed(67)
#declare t_chair_wood=texture{T_Wood11 scale 12 rotate -90*x finish{metallic}}
#declare t_chair_seat=
texture{
 gradient z
 texture_map{
   [0.0 pigment{DarkTan/3} normal{gradient x 1 }]
   [0.5 T_Wood11 normal{gradient x 1 } finish{Shiny}]
   [1.0 pigment{DarkTan/3} normal{gradient x 1 }]
 }
 rotate 90*y
 scale 1.1
}
#declare rad_bg=.6
#declare rad_sg=.45
#declare rad_leg=2.1
#include "i_chair.inc"
object{silla
 translate <60,0,20>
}
#end

// ----------------------------------------------------------------------------


// *** CAMERAS
// +++ main camera
#include "i_camera.inc"
camera{
 location cam_from
 direction cam_zoom
 look_at cam_to
}


// ----------------------------------------------------------------------------


// *** LIGHTS
#declare light_color=White+Gold

// +++ main light
light_source{
 <100,200,-10>
 light_color
 #if (trace_area=1)
  area_light
  <0, 0, 64> <0, 64, 0>
  4, 4
  adaptive 1
  jitter
 #end
 fade_distance 200
 fade_power 4
}
// +++ ambient light
#if (trace_ambient_light=1)
 light_source{
  cam_from
  light_color*.2
  fade_distance cam_from.z
  fade_power 8
  shadowless
 }
#end


// ----------------------------------------------------------------------------




