/*
  I_BARR00.INC

   Creates pieces for the barrel (must be called prior to I_BARREL.INC).

  *

  Jaime Vives, no(C)-1998. Valencia (Spain).

*/


// *** CREATE BARREL PIECES ***

// +++ basic shape +++
#declare base_object=
difference{
 intersection{
  sphere{
   <0,0,0>,1
   scale <barrel_radius,barrel_height*.8,barrel_radius>
  }
  plane{y,barrel_height*.5}
  plane{y,-barrel_height*.5 inverse}
 }
 sphere{
  <0,0,0>,0.95
  scale <barrel_radius,barrel_height*.8,barrel_radius>
 }
}

// +++ cut a lamina +++
#declare lamina=
intersection{
 object{base_object}
 plane{x,0 inverse}
 plane{x,0 rotate -lam_ang*y}
}

// +++ assemble the body with the laninas +++
#declare num_lam=360/lam_ang
#declare cnt_lam=1
#declare body=
union{
 #while (cnt_lam<=num_lam)
  object{lamina
   scale 0.99
   texture{t_barrel_wood
    scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
    translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
   }
   translate -.2*z
   rotate (360*cnt_lam/num_lam)*y
  }
  #declare cnt_lam=cnt_lam+1
 #end
}

// +++ small ring (upper & lower rings) +++
#declare small_ring=
intersection{
 object{base_object scale 1.01}
 plane{y,barrel_height*.45-5}
 plane{y,barrel_height*.45-8 inverse}
 texture{t_barrel_metal
  translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
 }
}

// +++ big ring (central rings) +++
#declare big_ring=
intersection{
 object{base_object scale 1.01}
 plane{y,barrel_height*.2-5}
 plane{y,barrel_height*.2-8 inverse}
 texture{t_barrel_metal
  translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
 }
}

// +++ top ring (top & bottom rings) +++
#declare top_ring=
intersection{
 object{base_object scale 1.01}
 plane{y,barrel_height*.5}
 plane{y,barrel_height*.5-3 inverse}
 texture{t_barrel_metal
  translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
 }
}

// +++ barrel lid shape +++
#declare lid_base=
intersection{
 intersection{
  sphere{
   <0,0,0>,1
   scale <barrel_radius,barrel_height*.8,barrel_radius>
  }
  plane{y,barrel_height*.5}
  plane{y,-barrel_height*.5 inverse}
 }
 plane{y,barrel_height*.5-1}
 plane{y,barrel_height*.5-2 inverse}
}

// +++ cut & assemble barrel lid laminas +++
#declare barrel_lid=
union{
 intersection{
  object{lid_base}
  plane{x,-0.005}
  plane{x,-barrel_radius*.245 inverse}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 intersection{
  object{lid_base}
  plane{x,0.005 inverse}
  plane{x,barrel_radius*.245}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 #if (top_hole=1)
 difference{
  intersection{
   object{lid_base}
   plane{x,-barrel_radius*.255}
   plane{x,-barrel_radius*.495 inverse}
  }
  cylinder{
   <-barrel_radius*(.255+.125),barrel_height*.5-5,0>
   <-barrel_radius*(.255+.125),barrel_height*.5+5,0>
   barrel_radius*.1
  }
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 #else
 intersection{
  object{lid_base}
  plane{x,-barrel_radius*.255}
  plane{x,-barrel_radius*.495 inverse}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 #end
 intersection{
  object{lid_base}
  plane{x,barrel_radius*.255 inverse}
  plane{x,barrel_radius*.495}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 intersection{
  object{lid_base}
  plane{x,-barrel_radius*.505}
  plane{x,-barrel_radius*.745 inverse}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 intersection{
  object{lid_base}
  plane{x,barrel_radius*.505 inverse}
  plane{x,barrel_radius*.745}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 intersection{
  object{lid_base}
  plane{x,-barrel_radius*.755}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
 intersection{
  object{lid_base}
  plane{x,barrel_radius*.755 inverse}
  texture{t_barrel_wood rotate 90*x
   scale barrel_radius*.2+barrel_radius*.3*rand(r_wood)
   translate <barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood),barrel_height*100*rand(r_wood)>
  }
 }
}
