/*
  BARREL.INC

    Creates a different barrel at each call (needs I_BARR00.INC).

  *

  Jaime Vives, no(C)-1998. Valencia (Spain).

  *

  USAGE:

    The following variables and textures must exist prior to the calls :

      + r_wood         -> Random seed used to randomize things
      + barrel_height  -> Barrel height (1 unit = 1 cm)
      + barrel_radius  -> Barrel major radius (1 unit = 1 cm)
      + lam_ang        -> Cut angle for barrel lanimas (0/360)
      + top_hole       -> 1/0 = top hole on/off
      + t_barrel_wood  -> Wood texture for the barrel
      + t_barrel_metal -> Metal used for barrel rings

    You need also to call both include files as follows :

      #include "barrel0.inc"
      #declare my_barrel=#include barrel.inc

   And now, you have a barrel object named "my_barrel".

*/

// +++ barrel construction +++
union{
 object{body}
 object{small_ring}
 object{small_ring rotate 180*x}
 object{big_ring}
 object{big_ring rotate 180*x}
 object{top_ring}
 object{top_ring rotate 180*x}
 object{barrel_lid rotate 360*rand(r_wood)*y}
 object{barrel_lid rotate 180*x rotate 360*rand(r_wood)*y}
}

