// --- MESH APPROXIMATOR AND SURFACE DISPLACEMENT MACROS ---
// --- by BILL PRAGNELL, 2008 ---
// --- http://www.infradead.org/~wmp/ ---
// --- This file is licensed under the terms of the CC-LGPL ---

#include "colors.inc"
#include "meshrelief.inc"

global_settings { assumed_gamma 1 }

camera {
  location <0, 4, -6>
  up <0, 1, 0>
  right <4/3, 0, 0>
  angle 45
  look_at <0, 0, 0> }

light_source { <50, 50, -20> color White }

// declare pigment for perturbation
#declare p1 = 
pigment { 
 average
 pigment_map{
   [1 granite scale <1,1,1> translate 3]
   [1 agate translate 2]   
 }
 scale 2 
}

object {
  Weathered_Cone(<0,0,0>,0.75,<0,1,0>,0.1,0.1, 80*4, pigment{p1}, 0.3, yes, yes, "stalactite1")
  pigment { color rgb <0.2,0.5,1> }
  finish { ambient 0 phong 1 phong_size 50 } 
  translate -1*x
}

object {
  Weathered_Cone(<0,0,0>,0.75,<0,1,0>,0.1,0.1, 80*4, pigment{p1 translate 13}, 0.3, yes, yes, "stalactite2")
  pigment { color rgb <0.2,0.5,1> }
  finish { ambient 0 phong 1 phong_size 50 } 
  translate 1*x
}

plane { <0, 1, 0>, 0 pigment { checker color White, color Gray80 } finish { ambient 0 } }
