// --- MESH APPROXIMATOR AND SURFACE DISPLACEMENT MACROS ---
// --- by BILL PRAGNELL, 2008 ---
// --- http://www.infradead.org/~wmp/ ---
// --- This file is licensed under the terms of the CC-LGPL ---

#include "colors.inc"
#include "meshrelief.inc"

global_settings { assumed_gamma 1 }

camera {
  location <0, 4, -6>
  up <0, 1, 0>
  right <4/3, 0, 0>
  angle 45
  look_at <0, 0, 0> }

light_source { <50, 50, -20> color White }

// declare pigment for perturbation
#declare p1 = 
pigment { 
 gradient y
 pigment_map{
   [0.5 granite turbulence .33 rotate 123]
   [1 rgb 0]   
 }
 scale 2 
}

#declare stalagm=
merge{
  //cylinder{0,1*y,.5}
  cone{0,.75,1*y,.5}
  sphere{0,.5 translate 1*y}
  translate -.75*y
}
#declare i_stalagm=
sphere{0,.49}

object {
  MeshShape(stalagm, i_stalagm, 0, 50*6, pigment{p1 translate 13}, .2, yes, yes, "stalagmite1")
  pigment { color rgb <0.2,0.5,1> }
  finish { ambient 0 phong 1 phong_size 50 } 
  translate .75*y
  translate -1*x
}

object {
  MeshShape(stalagm, i_stalagm, 0, 50*6, pigment{p1 translate 21}, .2, yes, yes, "stalagmite2")
  pigment { color rgb <0.2,0.5,1> }
  finish { ambient 0 phong 1 phong_size 50 } 
  translate .75*y
  translate 1*x
}

plane { <0, 1, 0>, 0 pigment { checker color White, color Gray80 } finish { ambient 0 } }
