// --- MESH APPROXIMATOR AND SURFACE DISPLACEMENT MACROS ---
// --- by BILL PRAGNELL, 2008 ---
// --- http://www.infradead.org/~wmp/ ---
// --- This file is licensed under the terms of the CC-LGPL ---

#include "colors.inc"
#include "meshrelief.inc"

global_settings { assumed_gamma 1 }

camera {
  location <0, 4, -6>
  up <0, 1, 0>
  right <4/3, 0, 0>
  angle 45
  look_at <0, 0, 0> }

light_source { <50, 50, -20> color White }

// declare pigment for perturbation
#declare p1 = 
pigment { 
  average
  pigment_map{
    [1 crackle turbulence .33 scale .2]
    [1 granite]
  } 
  scale 2 
}

object {
  Weathered_Spheroid(<0.5,0.5,0.5>, 80*4, p1, -0.5, yes, yes, "stone")
  translate 0.5*y
  pigment { color rgb <0.2,1,0.5> }
  finish { ambient 0 phong 1 phong_size 50 } }


plane { <0, 1, 0>, 0 pigment { checker color White, color Gray80 } finish { ambient 0 } }
