// -------------------------------------------------------------------------
// The Cave II
// --
// Jaime Vives Piqueres, Feb-Mar 2016
// --
// License: http://creativecommons.org/licenses/by-sa/4.0/
// --
// Criticism, comments and suggestions welcome at jaime@ignorancia.org
// --
// If there is ever any update to this code, it will be hosted at 
// http://www.ignorancia.org
// -------------------------------------------------------------------------
#version 3.7;

// *** required includes ***
#include "colors.inc"
#include "rad_def.inc"
#include "transforms.inc"
#include "CIE.inc"

// *** control center ***
#declare use_blur=7*0;        // blur samples (0=off)
#declare use_area=0;          // area light on/off
#declare use_rad=1;           // radiosity on/off
#declare use_media=0;         // cave mist on/off
#declare use_normals=0;       // texture normals on/off
#declare r_stone=seed(2418);  // seed for rocks size, stretching & placement
#declare r_stala=seed(1423);  // seed for stalagmite/stalactite size & placement 
#declare r_sun=seed(1161);    // sun random placement 

// *** global settings ***
global_settings{
  max_trace_level 9 
  #if (use_rad)
    radiosity{Rad_Settings(Radiosity_Fast, off, off)}
    //radiosity{Rad_Settings(Radiosity_Normal, off, off)}
    //radiosity{Rad_Settings(Radiosity_Final , off, off)}
  #end
}
#default{texture{finish{ambient 0 emission 0 diffuse 1}}}


// *** common rock texture settings ***
#declare rock="taller-piedra_multicolor" // image not provided: use your own
#declare f_rock=finish{
  specular albedo 0.1 roughness 0.02
}


// *** base cave ***
#declare t_cave=
texture{
  pigment{
    image_map{jpeg rock}
    turbulence .5 lambda 3
    scale .25
    warp{spherical}
  }
  finish{f_rock}
  #if(use_normals)
    normal{granite scale .25}
  #end
}
// rough cave model done with Wings3D
#include "cave-base-3.inc"
// ground heightfield
#declare hf_res=1024;
#declare cave_ground=
height_field{
  function hf_res,hf_res{
    pattern{
      granite
      turbulence .33
      poly_wave .5
    }
  }
  translate -.5
  scale <800,30,1200>
  texture{
    pigment{
      image_map{
        jpeg rock
      }
      turbulence .5 lambda 3
      scale 1
      rotate 90*x
    }
    finish{f_rock}
    #if(use_normals)
      normal{granite scale .2}
    #end
    scale 100
  }
  translate <0,-90,0>
}
// joid the base cave and the ground
#declare the_cave=
union{
  object{cave
    hollow
    #if (use_media)
      interior{media{intervals 1 samples 64 scattering{1,.00005}}}
    #end
    scale 200
    translate 50*y
  }
  object{cave_ground}
}
// a container surrounding the cave to avoid light coming through unexpected holes on the mesh
#declare t_container=texture{pigment{Gray}}
#include "cave_container.inc"
object{cave_container
  scale 200
  translate 50*y
}


// *** rocks ***
#include "stone.inc"
#declare piedra=
object{stone 
  scale 2
  scale 2.5
}
// fill with rocks the whole cave
#declare num_stn=6000;
#declare cnt=1;
#declare rocas=
union{
#while (cnt<=num_stn)
  #declare start=<-500+1000*rand(r_stone),-90+190*rand(r_stone),-450+1450*rand(r_stone)>;
  #declare sph=vrotate(<0,0,1>,<360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>);
  #declare Norm=<0,0,0>;
  #declare Inter=trace(the_cave,start,sph,Norm);
  #if (Norm.gray!=0 & Inter.y>-90) 
    object{piedra
      rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
      scale <1+rand(r_stone),.1+rand(r_stone),1+rand(r_stone)>
      scale 10*rand(r_stone)*rand(r_stone)
      Reorient_Trans(y,Norm)
      translate Inter
    }
  #end
  #declare cnt=cnt+1;
#end
  texture{
	  pigment{
      image_map{jpeg rock interpolate 2}
      turbulence .5 lambda 3
      warp{spherical}
      scale <1,1,1>    
    }
    #if(use_normals)
      normal{granite scale .025}
    #end
    finish{f_rock}
    scale 200
  }
}
// put aditional stones on the entrance
#declare num_stn=100;
#declare cnt=1;
#declare rocas_entrada=
union{
#while (cnt<=num_stn)
  #declare start=<0,0,-450>;
  #declare sph=vrotate(<0,1,0>,<0,0,360*rand(r_stone)>);
  #declare Norm=<0,0,0>;
  #declare Inter=trace(the_cave,start,sph,Norm);
  #if (Norm.gray!=0 & Inter.y>-90) 
    object{piedra
      rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
      scale <1+rand(r_stone),.1+rand(r_stone),1+rand(r_stone)>
      scale 10*rand(r_stone)*rand(r_stone)
      Reorient_Trans(y,Norm)
      translate Inter
    }
  #end
  #declare cnt=cnt+1;
#end
  texture{
	  pigment{
      image_map{jpeg rock interpolate 2}
      turbulence .5 lambda 3
      warp{spherical}
      scale <1,1,1>    
    }
    #if(use_normals)   
      normal{granite scale .025}
    #end
    finish{f_rock}
    scale 200
  }
}
// put little stones on the ground
#declare num_stn=20000;
#declare cnt=1;
#declare ground_stones=
union{
#while (cnt<=num_stn)
  #declare start=<-400+800*rand(r_stone),0,-350+850*rand(r_stone)>;
  #declare sph=<0,-1,0>;
  #declare Norm=<0,0,0>;
  #declare Inter=trace(the_cave,start,sph,Norm);
  #if (Norm.gray!=0) 
    object{piedra
      rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
      scale <1+rand(r_stone),1+rand(r_stone),1+rand(r_stone)>
      scale .1+.3*rand(r_stone)
      translate Inter
    }
  #end
  #declare cnt=cnt+1;
#end
  texture{
	  pigment{
      image_map{jpeg rock interpolate 2}
      turbulence .5 lambda 3
      warp{spherical}
      scale <1,1,1>    
    }
    #if(use_normals)
      normal{granite scale .025}
    #end
    finish{f_rock}
    scale 200
  }
}
object{ground_stones}
// joid the cave and the rocks
#declare the_cave=
union{
  object{the_cave}
  object{rocas}
  object{rocas_entrada}
}


// *** stalactites and stalagmites ***
#include "stalagmite1.inc"
#include "stalagmite2.inc"
#include "stalactite1.inc"
#include "stalactite2.inc"
#declare f_distrib=function{pigment{agate scale 500 translate 1000*rand(r_stala)}}
#declare num_stn=600;
#declare cnt=1;
#declare stalag1=
object{stalagmite1
  translate .65*y
  scale <10,25,10>/8
  scale .33
}
#declare stalag2=
object{stalagmite2
  translate .65*y
  scale <10,25,10>/8
  scale .33
}
#declare stalac1=
object{stalactite1
  scale <10,25,10>/6
  scale .5
}
#declare stalac2=
object{stalactite2
  scale <10,25,10>/6
  scale .5
}
#declare stala_all=
union{
#while (cnt<=num_stn)
  #declare disp=100*rand(r_stala);
  #declare est_rad=.5+rand(r_stala);
  #declare est_h=1+2*rand(r_stala);
  #declare start=<-500+1000*rand(r_stala),0,-400+1250*rand(r_stala)>;
  #if(f_distrib(start.x,0,start.z).gray>.8)
    #declare sph=<0,-1,0>;
    #declare Norm=<0,0,0>;
    #declare Inter=trace(the_cave,start,sph,Norm);
    #if (vlength(Norm)!=0) // & Inter.y>-90) 
      #declare start2=<Inter.x,0,Inter.z>;
      #declare sph2=<0,1,0>;
      #declare Norm2=<0,0,0>;
      #declare Inter2=trace(the_cave,start2,sph2,Norm2);
      #if (vlength(Norm2)!=0) 
        object{
          #if(rand(r_stala)>.5)
            stalag1
          #else
            stalag2
          #end
          hollow
          rotate 360*rand(r_stala)*y
          scale <est_rad,est_h,est_rad>
          scale 10+20*rand(r_stala)*rand(r_stala)
          translate Inter-1*y
        }
        object{
          #if(rand(r_stala)>.5)
          stalac1
          #else
          stalac2
          #end
          hollow
          rotate 180*x
          rotate 360*rand(r_stala)*y
          scale <est_rad,est_h,est_rad>
          scale 15+20*rand(r_stala)*rand(r_stala)
          translate Inter2+10*y
        }
      #end
    #end
    #declare cnt=cnt+1;
  #end
#end
  texture{
	  pigment{
      image_map{jpeg rock}
      turbulence <.5,1,.5> lambda 3
      warp{spherical}
      scale <1,1,1>    
    }
    #if(use_normals)
      normal{granite scale .025}
    #end
    finish{f_rock}
    scale 200
  }
  interior{ior 1.54}
}
// extra thin stalatites on the ceil
#declare num_stn=5000;
#declare cnt=1;
#declare stalac=
object{stalactite1
  scale <6,12,6>/8
}
#declare extra_stalactites=
union{
#while (cnt<=num_stn)
  #declare est_rad=1+8*rand(r_stala);
  #declare est_h=1+2*rand(r_stala);
  #declare start=<-500+1000*rand(r_stala),100,-400+1250*rand(r_stala)>;
  #declare sph=<0,1,0>;
  #declare Norm=<0,0,0>;
  #declare Inter=trace(the_cave,start,sph,Norm);
  #if (vlength(Norm)!=0) 
    object{
      stalac
      hollow
      rotate 180*x
      rotate 360*rand(r_stala)*y
      scale <est_rad,est_h,est_rad>
      scale (5+10*rand(r_stala))*y
      translate Inter+2*y
    }
  #end
  #declare cnt=cnt+1;
#end
  texture{
	  pigment{
      image_map{jpeg rock}
      turbulence <.5,1,.5> lambda 3
      warp{spherical}
      scale <1,1,1>    
    }
    #if(use_normals)
      normal{granite scale .025}
    #end
    finish{f_rock}
    scale 200
  }
  interior{ior 1.54}
}

// *** place it all ***
object{stala_all}
object{extra_stalactites}
object{the_cave}


// *** lighting ***
CIE_ColorSystemWhitepoint(CIE_ColSys, Illuminant_D55)
#declare Lightsys_Scene_Scale=10;
#include "lightsys.inc" 
#declare Cl_Daylight =Daylight(6500); 
#declare Cl_Skylight =Daylight(7500); 
#declare Lightsys_Brightness=1;
#ifndef(Al)    #declare Al=int(90*rand(r_sun)); #end
#ifndef(Az)    #declare Az=int(360*rand(r_sun)); #end
#ifndef(North) #declare North=<-1+2*rand(r_sun),0,-1+2*rand(r_sun)>; #end
#declare Intensity_Mult=4;
#declare Max_Vertices=1000;
#declare DomeSize=110000;
#include "CIE_Skylight"
#declare Cl_Sunlight =Blackbody(3000+4500*Al/90); 
light_source{
  SolarPosition
  Light_Color(Cl_Sunlight,SunColor.gray)
  #if (use_area)
    area_light 2000*x,2000*z,8,8 jitter adaptive 1 orient circular
  #end
  fade_power 0
}
// exterior plane for extra light bounce
plane{y,-200 pigment{Gray}}


// *** camera ***
// outside test
//#declare clo=<-90,0,-1500>;
//#declare cla=<0,0,0>;
//#declare fp=cla;
// from the entrance
#declare clo=<-150,0,-500>;
#declare cla=<100,0,0>;
#declare fp=cla+400*z;
// from the interior
//#declare clo=<0,0,400>;
//#declare cla=<0,0,0>;
//#declare fp=cla;
// from a side
//#declare clo=<-300,0,0>;
//#declare cla=<400,0,0>;
//#declare fp=cla;
camera{
  location clo
  up 1*y
  right image_width/image_height*x
  angle 54.4 
  look_at cla
  #if (use_blur)
    focal_point fp
    aperture 2.5
    blur_samples use_blur
  #end
}

