// *** NUT ***
#macro Tuerca(r_tornillo,t_tornillo,k)

height_field{
 gif "hf_tue2"
 water_level 0.001
 translate -.5
 rotate -90*x
 scale <k,k,k/2>
 texture{t_tornillo translate 100*rand(r_tornillo)}
}

#end

// *** STEP ***
#macro Peldanyo(r_peld,t_peld)

 union{
  intersection{
   torus{3,1}
   plane{x,0}
   plane{z,0}
   translate -10*x
  }
  intersection{
   torus{3,1}
   plane{x,0 inverse}
   plane{z,0}
   translate 10*x
  }
  cylinder{<-10,0,-3>,< 10,0,-3>,1}
  cylinder{<-13,0, 0>,<-13,0,15>,1}
  cylinder{< 13,0, 0>,< 13,0,15>,1}
  object{Tuerca(r_peld,t_peld,4)
   translate <-13,0,8>
  }
  object{Tuerca(r_peld,t_peld,4)
   translate <13,0,8>
  }
  texture{t_peld translate 100*rand(r_peld)}
 }

#end

// *** SCREW ***
#macro Tornillo(r_tornillo,t_tornillo)

height_field{
 gif "hf_tuer"
 water_level 0.001
 translate -.5
 rotate -90*x
 scale <2,2,1>
 texture{t_tornillo translate 100*rand(r_tornillo)}
}

#end

// *** TUBE WITH ELBOW AND WHEEL***
#macro Tubo(r_tubo,t_tubo,t_vol)

union{
 cylinder{
  <0,0, 0.6>
  <0,0, 1.7>
  7
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,0,-0.5>
  <0,0, 0.5>
  7
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,0,-0.5>
  <0,0,-2.5>
  5
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,0,-2.5>
  <0,0,-4.5>
  4
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 intersection{
  torus{8,4 rotate -90*z}
  plane{z,0}
  plane{y,0 inverse}
  texture{t_tubo translate 100*rand(r_tubo)*x}
  translate <0,-8,-4.5>
 }
 cylinder{
  <0, -8,-12.5>
  <0,-300,-12.5>
  4
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 6, 0,-1>}
 object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate <-6, 0,-1>}
 object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 0, 6,-1>}
 object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 0,-6,-1>}
 union{
  object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 6, 0,-1>}
  object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate <-6, 0,-1>}
  object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 0, 6,-1>}
  object{Tornillo(r_tubo,t_tubo) rotate (360*rand(r_tubo))*z translate < 0,-6,-1>}
  rotate 45*z
 }
 // volante
 cylinder{
  <0,-10,-12.5>
  <0,-20,-12.5>
  4.5
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,-10,-12.5>
  <0,-10.5,-12.5>
  5
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,-19.5,-12.5>
  <0,-20,-12.5>
  5
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
 torus{2,.25
  rotate -90*x
  translate <0,-15,-17>
  texture{t_vol translate 100*rand(r_tubo)*x}
 }
 torus{2,.25
  rotate -90*x
  translate <0,-15,-20>
  texture{t_vol translate 100*rand(r_tubo)*x}
 }
 cylinder{
  <0,-15,-12.5>
  <0,-15,-20>
  2
  texture{t_vol translate 100*rand(r_tubo)*x}
 }
 union{
  torus{8,1 rotate -90*x}
  torus{2,.5 rotate -90*x translate 1*z}
  cone{<0,8,0>,1,<0,2,1>,.6}
  cone{<0,8,0>,1,<0,2,1>,.6 rotate 120*z}
  cone{<0,8,0>,1,<0,2,1>,.6 rotate -120*z}
  rotate 360*rand(r_tubo)*z
  texture{t_vol translate 100*rand(r_tubo)*x}
  translate <0,-15,-21>
 }
 object{Tuerca(r_tubo,t_tubo,3.5) rotate (360*rand(r_tubo))*z translate <0,-15,-20.5>}
 cylinder{
  <0,-15,-21>
  <0,-15,-20>
  1
  texture{t_tubo translate 100*rand(r_tubo)*x}
 }
}

#end
