/*

  TUBOS (Close-up of an abandoned factory)

  Exercice on Old, dirty and rusted stuff.

  Jaime Vives Piqueres, no(C)1999

*/


// *** GLOBAL ***
#version 3.1;
global_settings{
 max_trace_level 10
 ambient_light 0.1
}


// *** BASICS ***
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"
#include "stones.inc"


// *** RENDER CONTROL ***
#declare trace_wall =1;
#declare trace_tubes=1;
#declare trace_rest =1;
#declare trace_area =0;


// *** TEXTURES ***
// --- wall brick texture ---
#declare t_wall=
texture{
 pigment{
  gradient z
  turbulence 0.1
  color_map{
   [0 Orange*.5+Flesh*.5]
   [1 Tan*.5+Flesh*.5]
  }
 }
 normal{granite}
}
// --- dirty textures ---
#declare t_dirty=
texture{
 pigment{
  gradient y
  turbulence 0.3
  octaves 1
  color_map{
   [0.0 DarkTan/4 filter 0.1]
   [0.2 DarkTan/4 filter 0.2]
   [1.0 Clear]
  }
  scale <0.03,1,1>
 }
 scale <1,2,1>
 translate .75*y
}
#declare t_dirty2=
texture{
 pigment{
  dents
  turbulence 0.3
  color_map{
   [0.0 DarkTan filter 0.9]
   [0.2 DarkTan filter 0.95]
   [0.5 Clear]
   [1.0 Clear]
  }
 }
 scale .05
}
texture{
 pigment{
  gradient y
  turbulence 0.3
  octaves 1
  color_map{
   [0.0 DarkTan filter 0.9]
   [1.0 Clear]
  }
  scale <0.03,1,1>
 }
 normal{granite}
 scale <1,2,1>
 translate .75*y
}
#declare t_dirty3=
texture{
 pigment{
  gradient y
  turbulence 0.3
  octaves 1
  color_map{
   [0.0 DarkTan/4 filter 0.8]
   [0.2 DarkTan/4 filter 0.9]
   [1.0 Clear]
  }
  scale <0.03,1,1>
 }
 scale <1,2,1>
 translate .75*y
}
#declare t_dirty4=
texture{
 pigment{
  bozo
  turbulence 0.8
  color_map{
   [0.0 DarkTan/2 filter 0.1]
   [0.05 DarkTan/2 filter 0.3]
   [0.5 Clear]
   [1.0 Clear]
  }
 }
}
// --- mortar texture ---
#declare t_wall_sep=
texture{
 pigment{DarkTan}
 normal{granite .15 scale .2}
}
// --- ruted texture for the tubes ---
#declare t_rusty=
 texture{
  pigment{
   granite
   color_map{
    [0 DarkTan*.3]
    [0.5 DarkBrown*.4]
    [1 Orange*.6]
   }
  }
  normal{granite scale .1}
  finish{metallic}
 }
// --- metal for the tubes ---
#declare t_metal=
 texture{
  pigment{
   wrinkles
   turbulence .3
   color_map{
    [0.00 DkGreenCopper*.1]
    [1.00 Copper]
   }
  }
  normal{crackle scale .1}
  finish{F_MetalB}
 }
// --- mix both on the final tube texture ---
#declare rusted_metal=
texture{
 wrinkles
 turbulence .3
 texture_map{
  [0.00 t_rusty]
  [0.30 t_rusty]
  [0.32 t_metal]
  [1.00 t_metal]
 }
 scale 2
}
/*
// original layered texture (pre-comments), replaced now by the texture_map
 texture{
  pigment{
   granite
   color_map{
    [0 DarkTan*.1]
    [0.5 DarkBrown*.1]
    [1 Orange*.2]
   }
  }
  normal{crackle}
  finish{metallic}
 }
 texture{
  pigment{
   wrinkles
   turbulence .3
   color_map{
    [0.00 Clear]
    [0.30 Clear]
    [0.32 DkGreenCopper*.1]
    [1.00 Copper]
   }
  }
  finish{F_MetalA}
  normal{crackle scale .2}
  translate 1
  scale 2
 }
*/
// --- ruted texture for the wheels ---
#declare rusted_red=
 texture{
  pigment{
   granite
   color_map{
    [0 DarkTan*.6]
    [0.5 DarkBrown*.7]
    [1 Orange*.8]
   }
  }
  normal{granite scale .1}
//  finish{metallic}
 }
 texture{
  pigment{
   wrinkles
   turbulence .3
   color_map{
    [0.00 Clear]
    [0.40 Clear]
    [0.42 Red*.4+Gray20]
    [1.00 DarkTan*.4+Gray20]
   }
  }
  normal{crackle scale .09}
  finish{metallic}
  translate 1
  scale 2
 }
 texture{
  pigment{Clear}
  normal{
   wrinkles 1
   turbulence .3
   slope_map{
    [0.00 <0,0>]
    [0.40 <0,0>]
    [0.42 <1,0>]
    [1.00 <1,0>]
   }
  }
//  finish{ambient 0 brilliance 0}
  scale 2
  translate 1
 }


// **** CONCRETE WALL (done with a modified version of wall.inc ***
#if (trace_wall)
#declare a_hfs=array[8]
#declare a_hfs[0]="brick01"
#declare a_hfs[1]="brick02"
#declare a_hfs[2]="brick03"
#declare a_hfs[3]="brick04"
#declare a_hfs[4]="brick05"
#declare a_hfs[5]="brick06"
#declare a_hfs[6]="brick07"
#declare a_hfs[7]="brick08"
#include "wall.inc"
#declare max_rows=6;
#declare max_cols=4;
#declare x_size=50;
#declare y_size=25;
#declare wall=
union{
 // --- bricks ---
 object{
  f_wall(      // MACRO from wall.inc, parameters are:
   max_rows,   //  + maximun number of rows of bricks
   max_cols,   //  + maximum number of columns of bricks
   x_size,     //  + lenght of the x side (width) of the brick
   y_size,     //  + lenght of the y side (height) of the brick
   1.01        //  + scaling factor for x and y sizes
   .6,         //  + thinyness of the brick (z side)
   .1,         //  + max rand displacement in z
   on,         //  + alternate row displacement (on/off)
   on,         //  + alernate rotation (on/off)
   0,          //  + brick random factor (0 to 1/none to full)
   t_wall,     //  + texture for the bricks
   t_dirty,    //  + texture for the dirt
   on,         //  + randomize texture in z direction (on/off)
   off,        //  + randomize texture scaling (on/off)
   100,        //  + texture scaling factor
   .1,         //  + water_level
   a_hfs,      //  + array of HF brick file names
   1           //  + format of HF files (0=TGA,1=GIF,2=PNG,3=SYS)
   2868
  )
  translate ((max_rows*.5)*y_size)*y
 }
 // --- mortar ---
 box{
  <-max_cols*x_size*.5,0,10>
  <(max_cols)*x_size*.5,max_rows*y_size,10.01>
  texture{t_wall_sep}
 }
}
object{wall}
#end


// *** TUBES ***
#if (trace_tubes)
 #include "i_tubos.inc"
 #declare r_rust=seed(12);
 // --- main tubes ---
 object{Tubo(r_rust,rusted_metal,rusted_red) translate <0,111,-2.1>}
 object{Tubo(r_rust,rusted_metal,rusted_red) translate <-15,131,-2.1>}
 object{Tubo(r_rust,rusted_metal,rusted_red) translate < 15,91,-2.1>}
 // --- steps on the wall (for reflections) ---
 #declare r_peld=seed(36);
 object{Peldanyo(r_peld,rusted_metal) translate <45, 55,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45, 75,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45, 95,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,115,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,135,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,155,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,175,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,195,-9>}
 object{Peldanyo(r_peld,rusted_metal) translate <45,215,-9>}
 // --- other non visible tubes ---
 #declare tubo_lateral_1=cylinder{<0,0,-1000>,<0,0,10>,7}
 #declare tubo_lateral_2=cylinder{<0,0,-1000>,<0,0,10>,4}
 #declare tubo_lateral_3=cylinder{<0,0,-1000>,<0,0,10>,2}
 object{tubo_lateral_1 texture{rusted_metal} translate <-200+7,300-7,0>}
 object{tubo_lateral_1 texture{rusted_metal} translate <-200+7,300-7*3,0>}
 object{tubo_lateral_1 texture{rusted_metal} translate < 200-7,300-7,0>}
 object{tubo_lateral_1 texture{rusted_metal} translate < 200-7,300-7*3,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate <-200+4,250,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate < 200-4,250,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate <-200+4,250-4*2,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate < 200-4,250-4*2,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate <-200+4,250-4*4,0>}
 object{tubo_lateral_2 texture{Chrome_Texture} translate < 200-4,250-4*4,0>}
 object{tubo_lateral_1 texture{pigment{GreenCopper} finish{F_MetalA}} translate <-200+7,200-7,0>}
 object{tubo_lateral_1 texture{pigment{GreenCopper} finish{F_MetalA}} translate <-200+7,200-7*3,0>}
 object{tubo_lateral_1 texture{pigment{GreenCopper} finish{F_MetalA}} translate < 200-7,200-7,0>}
 object{tubo_lateral_1 texture{pigment{GreenCopper} finish{F_MetalA}} translate < 200-7,200-7*3,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate <-200+4,150,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate < 200-4,150,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate <-200+4,150-4*2,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate < 200-4,150-4*2,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate <-200+4,150-4*4,0>}
 object{tubo_lateral_2 texture{pigment{Yellow/2 + Orange/2} finish{Shiny}} translate < 200-4,150-4*4,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate <-200+7,100-7,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate <-200+7,100-7*3,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate < 200-7,100-7,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate < 200-7,100-7*3,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate <-200+7,100-7*5,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate <-200+7,100-7*7,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate < 200-7,100-7*5,0>}
 object{tubo_lateral_1 texture{pigment{CoolCopper} normal{granite} finish{F_MetalA}} translate < 200-7,100-7*7,0>}
#end


// *** POWER BOX ***
#declare pw_box_box=
intersection{
 difference{
  superellipsoid{<.1,.1>}
  superellipsoid{<.1,.1> scale 0.95}
  rotate 90*x
  scale <20,20,5>
 }
 plane{z,-4 inverse}
 texture{pigment{DarkGreen} normal{granite} finish{Phong_Shiny}}
 texture{t_dirty2 rotate 90*y scale 10}
}
#declare pw_box_cover=
intersection{
 difference{
  superellipsoid{<.1,.1>}
  superellipsoid{<.1,.1> scale 0.95}
  rotate 90*x
  scale <20,20,5>
 }
 plane{z,-4}
 texture{
  material_map{
   gif "mm_cov2"
   texture{pigment{DarkGreen} finish{Phong_Shiny} normal{granite scale .01}}
   texture{pigment{Yellow} finish{Shiny} normal{crackle .1 scale .06}}
   texture{pigment{Gray10} finish{Shiny} normal{crackle .1 scale .06}}
  }
  translate -.5
  scale <40,40,1>
 }
}
#declare pw_box_cover2=      // tricky layer
intersection{
 difference{
  superellipsoid{<.1,.1>}
  superellipsoid{<.1,.1> scale 0.95}
  rotate 90*x
  scale <20,20,5>
 }
 plane{z,-4.5}
 no_shadow
 hollow
 texture{t_dirty3 scale <10,20,10>}
}
#declare pw_tube=
union{
 cylinder{<0,-29,-2>,<0,-120,-2>,2}
 torus{2.5,.5 translate <0,-30.5,-2>}
 texture{rusted_metal}
}
#declare pw_box=
union{
 union{
  object{pw_box_box}
  object{pw_box_cover translate -0.2*z}
  object{pw_box_cover2 translate -0.201*z}
  translate -10*y
 }
 object{pw_tube translate -2.5*x}
 object{pw_tube translate  2.5*x}
 object{pw_tube translate -7.5*x}
 object{pw_tube translate  7.5*x}
}
object{pw_box
 translate <-50,120,-5>
}


// *** POOR LIGHT ***
#declare light_color=Turquoise*.5+Pink*.5+Gold;
#if (trace_area)
 #declare light_color=light_color*1.5;
#end
light_source{
 < 190,270,-80>
 light_color
 #if (trace_area)
   area_light <0, 6, 0>, <0, 0, 6>, 4, 4
   adaptive 1
   jitter
 #end
 fade_distance 350
 fade_power 2
}


// *** CORRIDOR ***
box{
 <-200,0,10>
 < 200,300,20>
 texture{
  pigment{Flesh}
  normal{granite}
 }
}
box{
 <-200,  0,-1000>
 <-210,300,   10>
 texture{
  pigment{Flesh}
  normal{granite}
 }
 texture{
  pigment{
   dents
   turbulence 0.3
   color_map{
    [0.0 DarkTan filter 0.9]
    [0.2 DarkTan filter 0.95]
    [0.5 Clear]
    [1.0 Clear]
   }
  }
 }
}
box{
 <200,  0,-1000>
 <210,300,   10>
 texture{
  pigment{Flesh}
  normal{granite}
 }
}
box{
 <-200,300,-1000>
 < 200,310,   10>
 texture{
  pigment{Flesh}
  normal{granite}
 }
}
box{
 <-200,-10,-1000>
 < 200,  0,   10>
 texture{
  pigment{Flesh}
  normal{granite}
 }
}
box{
 <-200,  0,-1010>
 < 200,300,-1000>
 texture{
  pigment{Flesh}
  normal{granite}
 }
}


// *** ACTION! ***
camera{
 location <140,111,-60>
 direction 3.3*z
 look_at <7,100,0.1>
 rotate 30*y
}



