/*
   WALL.INC, pseudo-standard include file to do walls

   Jaime Vives Piqueres, no-(C)1998

   Version adapted for TUBOS.JPG:

    - added 2nd texture for dirty effects
*/

#macro f_wall(
  max_rows,     // maximun number of rows of bricks
  max_cols,     // maximum number of columns of bricks
  x_size,       // lenght of the x side (width) of the brick
  y_size,       // lenght of the y side (height) of the brick
  xy_scale      // scalinf factor for xy plane
  z_size,       // thinyness of the brick (z side)
  z_rand,       // max rand displacement in z
  row_disp,     // alternate row displacement (on/off)
  alt_rot       // alernate rotation (on/off)
  brick_rand,   // brick random factor (0 to 1/none to full)
  b_tex,        // texture for the bricks
  d_tex,        // texture for the dirt
  rand_z_tex,   // randomize texture in z direction (on/off)
  rand_scale,   // randomize texture scaling (on/off)
  tex_scale,    // texture scaling factor
  wl,           // water_level
  a_bricks      // array of HF brick file names
  hf_format     // format of HF files (0=TGA,1=GIF,2=PNG,3=SYS)
  r
 )

// *** constructing the wall... a double loop:
#declare rand_seed=seed(r);   // random seed for texturing and placement
#declare cnt_rows=1;            // rows counter
#declare displacement=0;        // displacement (0 or 0.5, alternatively)
#declare what_rot=0;            // rotation counter (0,90,180,270)
#declare what_brick=0;          // brick counter
#declare n=dimension_size(a_bricks,1);// number of bricks
union{

 #while (cnt_rows<=max_rows)

  #declare cnt_cols=1;          // columns counter
  #while (cnt_cols<=max_cols+2)

   height_field{
    #switch (hf_format)
     #case (0)
      gif
     #break
     #case (1)
      tga
     #break
     #case (2)
      png
     #break
     #case (3)
      sys
     #break
    #end
    a_bricks[what_brick]
    #if (what_brick=n-1)
      #declare what_wrick=0;
    #else
      #declare what_brick=what_brick+1;
    #end

    water_level wl
    translate -.5                // center
//    scale <xy_scale,xy_scale,1>
    rotate -90*x                 // place in front position

    #if (alt_rot)
     rotate what_rot*z                   // rotate next 90 degrees step
    #end
    texture{b_tex                       // texture randomly
     #if (rand_scale=1)
      scale -tex_scale*.5+tex_scale*rand(rand_seed)
     #end
     translate max_cols*rand(rand_seed)*x
     translate max_rows*rand(rand_seed)*y
     #if (rand_z_tex)
      translate z_size*tex_scale*rand(rand_seed)*z
     #end
    }
    texture{d_tex
     translate (z_size*tex_scale*rand(rand_seed))*z
    }
    translate <(cnt_cols-1)+displacement,(cnt_rows-1),z_rand*rand(rand_seed)>   // place the brick in the wall
   }
   #declare cnt_cols=cnt_cols+1;              // update counters
   #if (alt_rot)
    #if (what_rot=0)
      #declare what_rot=180;
    #else
     #if (what_rot=180)
       #declare what_rot=0;
     #end
    #end
   #end
   #if (rand(rand_seed)<brick_rand)          // randomize brick selection to patterns
    #declare what_brick=floor(n*rand(rand_seed));
   #end
  #end
  #declare cnt_rows=cnt_rows+1;
  #if (row_disp)
   #if (displacement=0)
     #declare displacement=0.5;
   #else
     #declare displacement=0;
   #end
  #end
 #end
 translate <-((max_cols+2)*.5)+.5,-(max_rows*.5)+.5,0> // center at <0,0,0>
 scale <x_size,y_size,z_size>           // scale properly
}

#end // end of macro f_wall()
